#include <iostream>
#include <vector>

using namespace std;

int main() {
  long long n, m, k; // Используем long long для больших значений
  cin >> n >> m >> k;

  vector<long long> color_counts(k, 0); // Вектор для хранения кол-ва клеток каждого цвета

  for (long long sum = 2; sum <= n + m; ++sum) { // Перебираем суммы координат клеток
    long long count = 0;
    long long row_start = max(1LL, sum - m); // Определяем начало строки
    long long row_end = min(n, sum - 1); // Определяем конец строки
    count = row_end - row_start + 1; // Количество клеток с суммой координат sum

    color_counts[(sum - 1) % k] += count; // Увеличиваем счетчик нужного цвета
  }

  for (int i = 0; i < k; ++i) {
    cout << color_counts[i] << endl; // Выводим результаты
  }

  return 0;
}
