#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

bool is_odd(int n) {
    if (n < 2) return true;
    int t = n;
    for (int i = 2; i * i <= t; ++i) {
        if (t % i == 0) {
            int c = 0;
            while (t % i == 0) {
                t /= i;
                c++;
            }
            if (c % 2 == 0) {
                return false;
            }
        }
    }
    return true;
}

void solve() {
    int m, l, r;
    if (!(cin >> m >> l >> r)) return;

    vector<bool> odd_status(r - l + 1, false);

    for (int i = l; i <= r; ++i) {
        if (is_odd(i)) {
            odd_status[i - l] = true;
        }
    }

    for (int i = 0; i <= r - l - m + 1; ++i) {
        bool found = true;
        for (int j = 0; j < m; ++j) {
            if (!odd_status[i + j]) {
                found = false;
                break;
            }
        }

        if (found) {
            for (int j = 0; j < m; ++j) {
                cout << l + i + j << (j == m - 1 ? "" : " ");
            }
            cout << endl;
            return;
        }
    }

    cout << -1 << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    solve();

    return 0;
}