#include <iostream>
using namespace std;

long long count_magic_up_to(long long n) {
    return (n / 7) + ((n + 3) / 10) - (n / 70);
}

long long find_kth_magic(long long k) {
    long long left = 1, right = k * 10;
    while (left < right) {
        long long mid = (left + right) / 2;
        if (count_magic_up_to(mid) < k)
            left = mid + 1;
        else
            right = mid;
    }
    return left;
}

int main() {
    long long k;
    cin >> k;
    cout << find_kth_magic(k);
    return 0;
}
