MOD = 10**9 + 7

def count_numbers(R_str, K):
    N = len(R_str)
    memo = {}

    def dp(pos, rem, tight):
        if pos == N:
            return int(rem == 0) % MOD
        
        key = (pos, rem, tight)
        if key in memo:
            return memo[key]
        
        result = 0
        limit = int(R_str[pos]) if tight else 9
        
        for digit in range(limit + 1):
            new_rem = (rem + bin(digit).count('1')) % K
            new_tight = tight and (digit == limit)
            result += dp(pos + 1, new_rem, new_tight)
            result %= MOD
        
        memo[key] = result
        return result
    
    return dp(0, 0, True)

# Чтение входных данных
if __name__ == "__main__":
    import sys
    input = lambda : sys.stdin.readline().strip()
    try:
        n, K = map(int, input().split())
        R = input()
        assert len(R) == n
        print(count_numbers(R, K))
    except Exception as e:
        print("Error:", str(e))
