MOD = 10**9 + 7

def count_numbers(R_str, K):
    # Длина числа R
    N = len(R_str)
    
    def dp(pos, rem, tight):
        """
        pos - текущая обрабатываемая позиция (справа налево)
        rem - остаток попкаунта от деления на K
        tight - булевый флаг, показывающий, находимся ли мы внутри верхней границы R
        
        Возвращает количество способов заполнить оставшиеся позиции,
        чтобы сумма единиц была кратна K.
        """
        if pos == N:
            return int(rem == 0) % MOD  # Проверяем условие кратности K
            
        result = 0
        limit = int(R_str[pos]) if tight else 9  # Максимальная возможная цифра
        
        for digit in range(limit + 1):  # Пробуем ставить разные цифры
            new_rem = (rem + bin(digit).count('1')) % K  # Обновляем остаток
            new_tight = tight and (digit == limit)       # Обновляем флаг ограничений
            result += dp(pos + 1, new_rem, new_tight)
            result %= MOD
        
        return result
    
    # Начинаем рекурсию с первого символа и начальным состоянием (осталось обработать всю строку)
    return dp(0, 0, True)

# Пример чтения ввода и вывода результата
if __name__ == "__main__":
    import sys
    input = sys.stdin.read
    data = input('s: ').split()
    n, K = map(int, data[:2])
    R = data[-1]
    print(count_numbers(R, K))
