#include <iostream>
#include <vector>

using namespace std;

const int MX = 1000000;
vector<int> sf(MX + 1);
vector<bool> is(MX + 1);

void sv() {
    for (int i = 2; i <= MX; ++i) sf[i] = i;
    for (int i = 2; i * i <= MX; ++i) {
        if (sf[i] == i) {
            for (int j = i * i; j <= MX; j += i) {
                if (sf[j] == j) sf[j] = i;
            }
        }
    }

    is[1] = true;
    for (int i = 2; i <= MX; ++i) {
        int t = i;
        bool ok = true;
        while (t > 1) {
            int p = sf[t];
            int c = 0;
            while (t % p == 0) {
                t /= p;
                c++;
            }
            if (c % 2 == 0) {
                ok = false;
                break;
            }
        }
        is[i] = ok;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    sv();

    int m, l, r;
    cin >> m >> l >> r;

    int c = 0;
    for (int i = l; i < l + m; ++i) {
        if (is[i]) c++;
    }

    if (c == m) {
        for (int i = l; i < l + m; ++i) {
            cout << i << " ";
        }
        return 0;
    }

    for (int s = l + 1; s <= r - m + 1; ++s) {
        if (is[s - 1]) c--;
        if (is[s + m - 1]) c++;

        if (c == m) {
            for (int i = s; i < s + m; ++i) {
                cout << i << " ";
            }
            return 0;
        }
    }

    cout << -1;

    return 0;
}
