#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;
using ll = long long;

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    int m, l, r;
    cin >> m >> l >> r;

    vector<int> min_div(r + 1, 0);
    for (int i = 2; i <= r; i++) {
        if (min_div[i] == 0) {
            for (int j = i; j <= r; j += i) {
                if (min_div[j] == 0) {
                    min_div[j] = i;
                }
            }
        }
    }

    vector<bool> nice_nums(r + 1, true);
    for (int i = 2; i <= r; i++) {
        int x = i;
        bool ok = true;

        while (x > 1) {
            int p = min_div[x];
            int cnt = 0;
            while (x % p == 0) {
                cnt++;
                x /= p;
            }
            if (cnt % 2 == 0) {
                ok = false;
                break;
            }
        }
        nice_nums[i] = ok;
    }

    int cnt = 0;
    int s = -1;

    for (int i = l; i <= r; i++) {
        if (nice_nums[i]) {
            cnt++;
            if (cnt >= m) {
                s = i - m + 1;
                break;
            }
        } else {
            cnt = 0;
        }
    }
    if (s == -1) {
        cout << -1 << endl;
    } else {
        for (int i = s; i < s + m; i++) {
            if (i > s) cout << " ";
            cout << i;
        }
    }

    return 0;
}