#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;
using ul = unsigned long long;

struct Point {
    double x, y;

    Point(double x = 0, double y = 0) : x(x), y(y) {}

    // Вычитание точек для получения вектора
    Point operator-(const Point& other) const {
        return Point(x - other.x, y - other.y);
    }

    // Сложение векторов/точек
    Point operator+(const Point& other) const {
        return Point(x + other.x, y + other.y);
    }

    // Умножение на скаляр
    Point operator*(double scalar) const {
        return Point(x * scalar, y * scalar);
    }

    // Скалярное произведение двух векторов (оператор *)
    double operator*(const Point& other) const {
        return x * other.x + y * other.y;
    }

    // Векторное произведение в 2D (оператор % - возвращает скаляр)
    double operator%(const Point& other) const {
        return x * other.y - y * other.x;
    }

    // Длина вектора
    double length() const {
        return std::sqrt(x * x + y * y);
    }
};

ll gcd(ll a, ll b) {
    return b == 0 ? a : gcd(b, a % b);
}

ll lcm(ll a, ll b) {
    return a / gcd(a, b) * b;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    ll m, l, r;
    cin >> m >> l >> r;

    vector<ll> spf(r + 1, 0);
    for (ll i = 2; i <= r; i++) {
        if (spf[i] == 0) {
            spf[i] = i;
            if (i * i <= r) {
                for (ll j = i * i; j <= r; j += i) {
                    if (spf[j] == 0) spf[j] = i;
                }
            }
        }
    }

    vector<bool> v(r + 1, true);
    v[0] = false;
    v[1] = true;

    for (ll n = 2; n <= r; n++) {
        ll x = n;
        bool f = true;

        while (x > 1) {
            ll p = spf[x];
            int cnt = 0;
            while (x % p == 0) {
                cnt++;
                x /= p;
            }
            if (cnt % 2 == 0) {
                f = false;
                break;
            }
        }
        v[n] = f;
    }

    ll count = 0;
    ll start = -1;

    for (ll i = l; i <= r; i++) {
        if (v[i]) {
            count++;
            if (count == m) {
                start = i - m + 1;
                break;
            }
        } else {
            count = 0;
        }
    }

    if (start == -1) {
        cout << -1 << "\n";
    } else {
        for (ll i = 0; i < m; i++) {
            cout << start + i << " ";
        }
        cout << "\n";
    }

    return 0;
}