#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;
using ul = unsigned long long;

struct Point {
    double x, y;

    Point(double x = 0, double y = 0) : x(x), y(y) {}

    // Вычитание точек для получения вектора
    Point operator-(const Point& other) const {
        return Point(x - other.x, y - other.y);
    }

    // Сложение векторов/точек
    Point operator+(const Point& other) const {
        return Point(x + other.x, y + other.y);
    }

    // Умножение на скаляр
    Point operator*(double scalar) const {
        return Point(x * scalar, y * scalar);
    }

    // Скалярное произведение двух векторов (оператор *)
    double operator*(const Point& other) const {
        return x * other.x + y * other.y;
    }

    // Векторное произведение в 2D (оператор % - возвращает скаляр)
    double operator%(const Point& other) const {
        return x * other.y - y * other.x;
    }

    // Длина вектора
    double length() const {
        return std::sqrt(x * x + y * y);
    }
};

ll gcd(ll a, ll b) {
    return b == 0 ? a : gcd(b, a % b);
}

ll lcm(ll a, ll b) {
    return a / gcd(a, b) * b;
}

vector<ll> sieve(ll n) {
    vector<bool> v(n + 1, true);
    v[1] = false;
    v[2] = true;
    for (ll i = 1;i <= n; i++) {
        if (v[i]) {
            for (ll j = i * 2; j <= n; j += i) {
                v[j] = false;
            }
        }
    }
    vector<ll> v1;

    for (ll i = 2; i <= n; i++) {
        if (v[i]) {
            v1.push_back(i);
        }
    }

    return v1;
}

long long fast_pow(long long base, long long exp) {
    long long res = 1;

    while (exp > 0) {
        if (exp % 2 == 1) {
            res *= base;
        }

        base *= base;
        exp /= 2;
    }

    return res;
}

vector<bool> sieve2(ll n) {
    vector<ll> prime = sieve(sqrt(n) + 1);
    vector<bool> v(n + 1, true);
    v[1] = false;

    for (ll i = 0; i < prime.size(); i++) {
        ll k = prime[i];
        for (ll j = 2; fast_pow(k, j) <= n; j += 2 ) {
            ll t = fast_pow(k, j);
            v[t] = false;
            for (ll b = 2;t * b <= n; b++) {
                if (t % b != 0) {
                    v[b * t] = false;
                }
            }
        }
    }

    return v;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(0);

    ll m, l, r;
    cin >> m >> l >> r;

    if (m > 4) {
        cout << -1 << endl;
        return 0;
    }

    vector<bool> v = sieve2(r + 1);

    ll lb = 0, rb = 0, cl = l, cr = l;

    for (ll i = l; i <= r; i++) {
        cl = i;
        while (i <= r and v[i]) {
            cr = i;
            i++;
        }
        if (cr - cl > rb - lb) {
            rb = cr;
            lb = cl;
        }
    }

    if (rb - lb + 1 < m) {
        cout << -1 << endl;
        return 0;
    }

    for (ll i = lb; i < lb + m; i++) {
        cout << i << " ";
    }

    return 0;
}