#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;
using ul = unsigned long long;

struct Point {
    double x, y;

    Point(double x = 0, double y = 0) : x(x), y(y) {}

    // Вычитание точек для получения вектора
    Point operator-(const Point& other) const {
        return Point(x - other.x, y - other.y);
    }

    // Сложение векторов/точек
    Point operator+(const Point& other) const {
        return Point(x + other.x, y + other.y);
    }

    // Умножение на скаляр
    Point operator*(double scalar) const {
        return Point(x * scalar, y * scalar);
    }

    // Скалярное произведение двух векторов (оператор *)
    double operator*(const Point& other) const {
        return x * other.x + y * other.y;
    }

    // Векторное произведение в 2D (оператор % - возвращает скаляр)
    double operator%(const Point& other) const {
        return x * other.y - y * other.x;
    }

    // Длина вектора
    double length() const {
        return std::sqrt(x * x + y * y);
    }
};

ll gcd(ll a, ll b) {
    return b == 0 ? a : gcd(b, a % b);
}

ll lcm(ll a, ll b) {
    return a / gcd(a, b) * b;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(0);

    ll k;
    cin >> k;

    ll l = 0, r = k + 1;
    ll ans = -1;
    bool flag = false;
    while (l  + 1< r) {
        if (flag) break;
        ll m = l + (r - l) / 2;
        ll f = (m - 1) * 7 / 10 + m - (m - 1) / 10;
        if (f <= k) {
            if (f == k) {
                ans = m;
            } else if (f == k - 1) {
                if ((m * 7) % 10 < 7) {
                    ans = m;
                    flag = true;
                } else {
                    ans = m + 1;
                }
            }
            l = m;
        } else {
            r = m;
        }
    }

    if (flag) {
        ll g = ans * 7;
        g /= 10;
        cout << g << 7 << endl;
    } else {
        cout << ans * 7 << endl;
    }

    return 0;
}