#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;
using ul = unsigned long long;

struct Point {
    double x, y;

    Point(double x = 0, double y = 0) : x(x), y(y) {}

    // Вычитание точек для получения вектора
    Point operator-(const Point& other) const {
        return Point(x - other.x, y - other.y);
    }

    // Сложение векторов/точек
    Point operator+(const Point& other) const {
        return Point(x + other.x, y + other.y);
    }

    // Умножение на скаляр
    Point operator*(double scalar) const {
        return Point(x * scalar, y * scalar);
    }

    // Скалярное произведение двух векторов (оператор *)
    double operator*(const Point& other) const {
        return x * other.x + y * other.y;
    }

    // Векторное произведение в 2D (оператор % - возвращает скаляр)
    double operator%(const Point& other) const {
        return x * other.y - y * other.x;
    }

    // Длина вектора
    double length() const {
        return std::sqrt(x * x + y * y);
    }
};

ll gcd(ll a, ll b) {
    return b == 0 ? a : gcd(b, a % b);
}

ll lcm(ll a, ll b) {
    return a / gcd(a, b) * b;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(0);

    ll n, m, k;
    cin >> n >> m >> k;

    vector<ll> ans(k + 1, 0);

    ll d = n + m - 1;

    ll l = min(n, m) - 1;
    ll r = min(n, m) - 1;
    d -= l + r;

    for (ll i = 1; i <= k; i++) {
        ans[i] = (((l / k) * i) + i) * (l / k) / 2;
        if (l % k != 0 and i <= l % k) {
            ans[i] += l / k + i;
        }
        ll os = (l + d) % k;
        if (l % k != 0) {
            ans[i] += (d - l % k) / k  * k;
        } else {
            ans[i] += d / k * k;
        }
        if (i <= os) {
            ans[i] += l + 1;
        }
        if (i > os) {
            ans[i] += l - i + 1;
        }
        r -= os;
        ans[i] += (l + i) * (r / k) / 2;
    }

    for (ll i = 1; i <= k; i++) {
        cout << ans[i] << "\n";
    }

    return 0;
}