#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

long long sum_ap(long long n, long long k, long long r)
{
    if (n == 0) return 0;
    long long first;
    if (r == 0)
    {
        first = k;
    }
    else
    {
        first = r;
    }
    if (first > n)
        return 0;
    long long count = (n - first) / k + 1;
    long long last = first + (count - 1) * k;
    return count * (first + last) / 2;
}

long long cnt(long long val, long long k, long long r)
{
    if (val == 0)
        return 0;
    long long first;
    if (r == 0)
    {
        first = k;
    }
    else
    {
        first = r;
    }
    if (first > val)
        return 0;
    return (val - first) / k + 1;
}

long long count_nums(long long start, long long end, long long k, long long r)
{
    if (start > end)
        return 0;
    return cnt(end, k, r) - cnt(start - 1, k, r);
}

int main()
{
    long long n, m, k;
    cin >> n >> m >> k;
    if (n > m) swap(n, m);
    vector  <long long> counts(k, 0);
    for (int c = 0; c < k; c++)
    {
        long long rem = (c + 1) % k;
        counts[c] += sum_ap(n, k, rem);
    }
    long long start_S = n + 2;
    long long end_S = m + 1;
    if (start_S <= end_S)
    {
        for (int c = 0; c < k; c++)
        {
            long long need = (c + 2) % k;
            long long diag = count_nums(start_S, end_S, k, need);
            counts[c] += diag * n;
        }
    }
    if (n > 1)
    {
         for (int c = 0; c < k; c++)
        {
            long long rhs = (n+m-1-c) % k;
            if (rhs < 0)
            {
                rhs += k;
            }
            long long x = rhs;
            counts[c] += sum_ap(n - 1, k, x);
        }
    }
    for (int i = 0; i < k; i++)
    {
        cout << counts[i] << endl;
    }
}
