#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    long long n, m, k;
    cin >> n >> m >> k;

    if (n > m)
        swap(n, m);

    long long full_cycles = (n + m - 1) / k;
    long long rem = (n + m - 1) % k;

    vector<long long> counts(k, 0);
    for (long long c = 0; c < k; ++c) {
        long long start_diag = c;
        long long cycles = full_cycles + (c < rem ? 1 : 0);

        long long sum_rising = n * (n + 1) / 2;
        long long sum_plateau = n * (m - n);
        long long sum_falling = m * (m + 1) / 2 - n * (n + 1) / 2;

        long long total = cycles * (sum_rising + sum_plateau + sum_falling);
        counts[c] = total / k;
    }

    long long total_cells = n * m;
    long long base = total_cells / k;
    long long extra = total_cells % k;

    for (long long i = 0; i < k; ++i) {
        counts[i] = base + (i < extra ? 1 : 0);
        cout << counts[i] << "\n";
    }

    return 0;
}
