#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    long long n, m, k;
    cin >> n >> m >> k;

    long long total_diags = n + m - 1;
    vector<long long> color_counts(k, 0);

    for (long long color = 0; color < k; ++color) {
        long long sum = 0;
        for (long long diag = color + 1; diag <= total_diags; diag += k) {
            long long diag_size = min({diag, n, m, n + m - diag});
            sum += diag_size;
        }
        color_counts[color] = sum;
    }

    for (int i = 0; i < k; ++i) {
        cout << color_counts[i] << "\n";
    }

    return 0;
}
