#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

using namespace std;

string prime_d(int n) {
    string d = "";
    int x = n;

    for (int p = 2; p * p <= x; p++) {
        while (x % p == 0) {
            d += to_string(p);
            x /= p;
        }
    }
    if (x > 1) {
        d += to_string(x);
    }
    return d;
}

int main(){
    int m, l, r;
    cin >> m >> l >> r;

    vector<int> result;

    for(int i = l; i <= r; i++){
        string d = prime_d(i);
        bool is_right = true;

        if(!d.empty()){
            sort(d.begin(), d.end());

            char cur = d[0];
            int count = 1;

            for(int j = 1; j < d.size(); j++){
                if(d[j] == cur){
                    count++;
                } else {
                    if(count % 2 == 0){
                        is_right = false;
                        break;
                    }
                    cur = d[j];
                    count = 1;
                }
            }
            if(count % 2 == 0){
                is_right = false;
            }
        }

        if(is_right){
            result.push_back(i);
            if(result.size() == m){
                for(int x : result){
                    cout << x << " ";
                }
                return 0;
            }
        } else {
            result.clear();
        }
    }
    cout << -1;
}
