#include <iostream>
#include <vector>
#include <string>
#include <algorithm> 
#include <map>       

using namespace std;


const int MOD = 1e9 + 7;

string R_bin; 
int K;       


string divide_by_2(string num) {
    string result = "";
    int carry = 0;
    for (char c : num) {
        int digit = c - '0' + carry * 10;
        result += (digit / 2) + '0';
        carry = digit % 2;
    }
    // Удаляем ведущие нули
    size_t first_digit = result.find_first_not_of('0');
    if (string::npos == first_digit) {
        return "0";
    }
    return result.substr(first_digit);
}

string decimalToBinary(string n_str) {
    string binary_str = "";
    if (n_str == "0") return "0";

    while (n_str != "0") {
        int last_digit = n_str.back() - '0';
        binary_str += (last_digit % 2 == 0 ? '0' : '1');
        n_str = divide_by_2(n_str);
    }
    reverse(binary_str.begin(), binary_str.end());
    return binary_str;
}



long long memo[100000][200][2][2]; 


vector<vector<vector<vector<long long>>>> memo_vec;
bool is_memo_filled[100000][200][2][2]; 

long long solve(int idx, int current_popcount_mod_K, bool is_less_than_R, bool is_leading_zero) {

    if (idx == R_bin.length()) {
        return (current_popcount_mod_K == 0 && !is_leading_zero); 
    const int MAX_K_FOR_DP = 200; 
    static long long dp[100000][MAX_K_FOR_DP][2][2]; 
    static bool visited[100000][MAX_K_FOR_DP][2][2];

    if (idx == R_bin.length()) {
        return (current_popcount_mod_K == 0 && !is_leading_zero);  
                                                                 
    }

    // Мемоизация
    if (visited[idx][current_popcount_mod_K][is_less_than_R][is_leading_zero]) {
        return dp[idx][current_popcount_mod_K][is_less_than_R][is_leading_zero];
    }

    long long ans = 0;
    int upper_bound = (is_less_than_R ? 1 : (R_bin[idx] - '0'));

    for (int digit = 0; digit <= upper_bound; ++digit) {
        if (is_leading_zero && digit == 0) { 
            ans = (ans + solve(idx + 1, current_popcount_mod_K, is_less_than_R || (digit < upper_bound), true)) % MOD;
        } else { 
            ans = (ans + solve(idx + 1, (current_popcount_mod_K + digit) % K, is_less_than_R || (digit < upper_bound), false)) % MOD;
        }
    }

    visited[idx][current_popcount_mod_K][is_less_than_R][is_leading_zero] = true;
    dp[idx][current_popcount_mod_K][is_less_than_R][is_leading_zero] = ans;
    return ans;
}


int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    string n_str_unused; 
    string R_decimal_str; 
    cin >> n_str_unused >> K;
    cin >> R_decimal_str;

    if (R_decimal_str == "0") { (for K>0).
        if (K == 1) {
            cout << 1 << endl; 
        } else {
             cout << 1 << endl; 
        }
        return 0;
    }
 
    if (K == 1) {

        string R_plus_1 = R_decimal_str;
        int i = R_plus_1.length() - 1;
        while (i >= 0 && R_plus_1[i] == '9') {
            R_plus_1[i] = '0';
            i--;
        }
        if (i < 0) {
            R_plus_1 = "1" + R_plus_1;
        } else {
            R_plus_1[i]++;
        }
       
        long long result_K1 = 0;
        for(char c : R_plus_1) {
            result_K1 = (result_K1 * 10 + (c - '0')) % MOD;
        }
        cout << result_K1 << endl;
        return 0;
    }


    R_bin = decimalToBinary(R_decimal_str);

    if (K > R_bin.length()) { 
 
    for (int i = 0; i <= R_bin.length(); ++i) { 
        for (int j = 0; j < K && j < MAX_K_FOR_DP; ++j) { 
            for (int l = 0; l < 2; ++l) {
                for (int z = 0; z < 2; ++z) {
                    dp[i][j][l][z] = -1; 
                }
            }
        }
    }
    
    
    
    long long final_answer = solve(0, 0, false, true);

    cout << final_answer << endl;

    return 0;
}
