#include <iostream>
using namespace std;
using ll = long long;

const int MOD = 1e9 + 7;

vector<int> dec_to_bin(const string &s) {
    vector<int> res;
    string t = s;
    while (!t.empty() && t != "0") {
        int rem = 0;
        string next;
        for (char c : t) {
            int num = rem * 10 + (c - '0');
            next.push_back(num / 2 + '0');
            rem = num % 2;
        }
        res.push_back(rem);
        while (!next.empty() && next[0] == '0') next.erase(next.begin());
        t = next;
    }
    reverse(res.begin(), res.end());
    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    ll K;
    cin >> n >> K;
    string R;
    cin >> R;

    vector<int> bits = dec_to_bin(R);
    int len = bits.size();

    vector<vector<vector<int>>> dp(len+1, vector<vector<int>>(2, vector<int>(K, 0)));
    dp[0][1][0] = 1; 

    for (int i = 0; i < len; i++) {
        for (int tight = 0; tight <= 1; tight++) {
            for (int rem = 0; rem < K; rem++) {
                int val = dp[i][tight][rem];
                if (val == 0) continue;
                for (int bit = 0; bit <= 1; bit++) {
                    if (tight && bit > bits[i]) continue;
                    int ntight = tight && (bit == bits[i]);
                    int nrem = (rem + bit) % K;
                    dp[i+1][ntight][nrem] = (dp[i+1][ntight][nrem] + val) % MOD;
                }
            }
        }
    }

    int ans = (dp[len][0][0] + dp[len][1][0]) % MOD;
    cout << ans << "\n";
}

