def precompute_non_even_power(max_n):
    """Предвычисляем, какие числа от 2 до max_n нечётно-степенные."""
    is_non_even_power = [True] * (max_n + 1)
    is_non_even_power[0] = is_non_even_power[1] = False  # по условию n ≥ 2

    for n in range(2, max_n + 1):
        temp = n
        factors = {}
        # Разложение на простые множители
        d = 2
        while d * d <= temp:
            while temp % d == 0:
                factors[d] = factors.get(d, 0) + 1
                temp //= d
            d += 1
        if temp > 1:
            factors[temp] = factors.get(temp, 0) + 1

        # Проверяем, все ли степени нечётны
        for exp in factors.values():
            if exp % 2 == 0:
                is_non_even_power[n] = False
                break

    return is_non_even_power

def find_sequence(m, l, r, is_non_even_power):
    """Находит первую последовательность из m подряд идущих нечётно-степенных чисел на [l; r]."""
    count = 0
    for i in range(l, r + 1):
        if is_non_even_power[i]:
            count += 1
            if count == m:
                start = i - m + 1
                return list(range(start, start + m))
        else:
            count = 0
    return [-1]

# Предвычисление для всех чисел до 10^6
MAX_N = 10**6
is_non_even_power = precompute_non_even_power(MAX_N)

# Чтение входных данных
import sys
input = sys.stdin.read().split()
m = int(input[0])
l, r = int(input[1]), int(input[2])

# Поиск и вывод результата
result = find_sequence(m, l, r, is_non_even_power)
print(' '.join(map(str, result)))
