import sys

def precompute_magic(max_n):
    """Предвычисляем, какие числа нечётно-степенные (до max_n)."""
    is_magic = [True] * (max_n + 1)  # is_magic[i] = True, если i — нечётно-степенное
    is_magic[0] = is_magic[1] = False  # по условию n ≥ 2

    # Для каждого числа от 2 до max_n проверяем разложение
    for n in range(2, max_n + 1):
        temp = n
        factors = {}
        # Разложение на простые
        d = 2
        while d * d <= temp:
            while temp % d == 0:
                factors[d] = factors.get(d, 0) + 1
                temp //= d
            d += 1
        if temp > 1:
            factors[temp] = factors.get(temp, 0) + 1

        # Проверяем, все ли степени нечётны
        for exp in factors.values():
            if exp % 2 == 0:
                is_magic[n] = False
                break

    return is_magic

def find_sequence(m, l, r, is_magic):
    """Находит первую последовательность из m подряд идущих нечётно-степенных чисел на [l; r]."""
    cnt = 0
    for i in range(l, r + 1):
        if is_magic[i]:
            cnt += 1
            if cnt == m:
                start = i - m + 1
                return list(range(start, start + m))
        else:
            cnt = 0
    return [-1]

# Предвычисление для всех чисел до 10^6
MAX_N = 10**6
is_magic = precompute_magic(MAX_N)

# Чтение входных данных
m = int(sys.stdin.readline())
l, r = map(int, sys.stdin.readline().split())

# Поиск и вывод результата
result = find_sequence(m, l, r, is_magic)
print(' '.join(map(str, result)))
