def count_cells_by_color(n, m, k):
    
    total_diagonals = n + m - 1
    counts = [0] * k  

    for d in range(total_diagonals):
        
        if d < min(n, m):
            cells_on_diag = d + 1
        elif d < max(n, m):
            cells_on_diag = min(n, m)
        else:
            cells_on_diag = n + m - 1 - d

        
        color_index = d % k
        counts[color_index] += cells_on_diag

    return counts



def main():
    
    try:
        n = int(input("Введите n (количество строк): "))
        m = int(input("Введите m (количество столбцов): "))
        k = int(input("Введите k (количество цветов): "))

        if n <= 0 or m <= 0 or k <= 0:
            print("Ошибка: n, m и k должны быть положительными числами.")
            return

        
        result = count_cells_by_color(n, m, k)

        
        print("\nКоличество клеток по цветам:")
        for i, count in enumerate(result, start=1):
            print(f"Цвет {i}: {count} клеток")

    except ValueError:
        print("Ошибка: введите целые числа.")
    except Exception as e:
        print(f"Произошла ошибка: {e}")




if __name__ == "__main__":
    main()
