MOD = 10 ** 9 + 7

import sys

sys.setrecursionlimit(10 ** 7)


def solve():
    input = sys.stdin.read
    data = input().split()
    n = int(data[0])
    K = int(data[1])
    R = data[2]

    from functools import lru_cache

    @lru_cache(None)
    def dp(pos, count_mod, restricted):
        if pos == n:
            return 1 if count_mod == 0 else 0

        limit = int(R[pos]) if restricted else 1
        result = 0
        for bit in range(limit + 1):
            new_restricted = restricted and (bit == limit)
            new_count_mod = (count_mod + (bit == 1)) % K
            result += dp(pos + 1, new_count_mod, new_restricted)
        return result % MOD

    answer = dp(0, 0, True)
    print(answer)