def solve():
    import sys
    sys.setrecursionlimit(10 ** 7)

    MOD = 10 ** 9 + 7
    input_data = sys.stdin.read().split()
    n = int(input_data[0])
    K = int(input_data[1])
    R_str = input_data[2]
    R_bin = bin(int(R_str))[2:]

    length = len(R_bin)

    from functools import lru_cache

    @lru_cache(None)
    def dfs(pos, popcount_mod, limit):
        if pos == length:
            return 1 if popcount_mod == 0 else 0

        max_bit = int(R_bin[pos]) if limit else 1
        result = 0
        for bit in range(max_bit + 1):
            next_limit = limit and (bit == max_bit)
            next_mod = (popcount_mod + bit) % K
            result += dfs(pos + 1, next_mod, next_limit)
        return result % MOD

    print(dfs(0, 0, True))