MOD = 10**9 + 7

def solve():
    import sys
    input = sys.stdin.read
    data = input().split()

    n = int(data[0])
    K = int(data[1])
    R_str = data[2]
    R_bin = bin(int(R_str))[2:]

    length = len(R_bin)

    from functools import lru_cache

    @lru_cache(None)
    def dfs(pos, sum_mod, limit):
        if pos == length:
            return 1 if sum_mod == 0 else 0

        max_bit = int(R_bin[pos]) if limit else 1
        total = 0
        for bit in range(max_bit + 1):
            next_limit = limit and (bit == max_bit)
            next_mod = (sum_mod + bit) % K
            total += dfs(pos + 1, next_mod, next_limit)
        return total % MOD

    print(dfs(0, 0, True))