import sys
sys.setrecursionlimit(10**7)

MOD = 10**9 + 7

n, K = map(int, sys.stdin.readline().split())
R_str = sys.stdin.readline().strip()

R_bin = bin(int(R_str))[2:]
length = len(R_bin)

from functools import lru_cache

@lru_cache(None)
def dfs(pos, pop_mod, restricted):
    if pos == length:
        return 1 if pop_mod == 0 else 0
    
    limit = int(R_bin[pos]) if restricted else 1
    result = 0
    for digit in range(limit + 1):
        new_restricted = restricted and (digit == limit)
        new_popcount = pop_mod + digit
        new_pop_mod = new_popcount % K
        result += dfs(pos + 1, new_pop_mod, new_restricted)
    return result % MOD

answer = dfs(0, 0, True)
print(answer)
