MOD = 10**9 + 7

import sys
sys.setrecursionlimit(10**7)

def main():
    input_data = sys.stdin.read().strip().split()
    n = int(input_data[0])
    K = int(input_data[1])
    R_dec = input_data[2]

    R_bin = bin(int(R_dec))[2:]

    @lru_cache(None)
    def dp(pos, popcount_mod, restricted):
        if pos == len(R_bin):
            return 1 if popcount_mod == 0 else 0

        limit_bit = int(R_bin[pos]) if restricted else 1
        result = 0
        for bit in range(limit_bit + 1):
            new_restricted = restricted and (bit == limit_bit)
            new_popcount_mod = (popcount_mod + bit) % K
            result += dp(pos + 1, new_popcount_mod, new_restricted)
        return result % MOD

    print(dp(0, 0, True))

if __name__ == "__main__":
    main()