def solve():
    import sys
    input = sys.stdin.read
    data = input().split()
    T = int(data[0])
    index = 1

    results = []

    for _ in range(T):
        n = int(data[index])
        index += 1
        rects = []
        for _ in range(n):
            x1, y1, x2, y2 = map(int, data[index:index + 4])
            index += 4
            rects.append((x1, y1, x2, y2))

        vert_lines = set()
        horz_lines = set()
        diag1_lines = set()  
        diag2_lines = set()
        for (x1, y1, x2, y2) in rects:
            vert_lines.add(x1)
            vert_lines.add(x2)
            horz_lines.add(y1)
            horz_lines.add(y2)
            diag1_lines.add(y1 - x1)
            diag1_lines.add(y2 - x2)
            diag2_lines.add(y1 + x1)
            diag2_lines.add(y2 + x2)


        def check_exists(lines_set, get_c):
            common_c = None
            for c in lines_set:
                if common_c is None:
                    common_c = c
                elif c != common_c:
                    return False
            return common_c is not None



        is_vertical_possible = len(vert_lines) > 0
        is_horizontal_possible = len(horz_lines) > 0
        is_diag1_possible = len(diag1_lines) > 0
        is_diag2_possible = len(diag2_lines) > 0

        answer = "No"
        if is_vertical_possible:
            pass
        if is_horizontal_possible:
            pass
        if is_diag1_possible:
            pass
        if is_diag2_possible:
            pass

        def can_line_exist(line_type, values):

            if line_type == 'vertical':
                # x = c
                for c in values:
                    if all(x1 <= c <= x2 for (x1, y1, x2, y2) in rects):
                        return True
            elif line_type == 'horizontal':
                # y = c
                for c in values:
                    if all(y1 <= c <= y2 for (x1, y1, x2, y2) in rects):
                        return True
            elif line_type == 'diag1':
                # y = x + c
                for c in values:
                    if all(y1 <= x1 + c <= y2 for (x1, y1, x2, y2) in rects):
                        return True
            elif line_type == 'diag2':
                # y = -x + c
                for c in values:
                    if all(y1 <= -x1 + c <= y2 for (x1, y1, x2, y2) in rects):
                        return True
            return False

        if (can_line_exist('vertical', vert_lines) or
                can_line_exist('horizontal', horz_lines) or
                can_line_exist('diag1', diag1_lines) or
                can_line_exist('diag2', diag2_lines)):
            results.append("Yes")
        else:
            results.append("No")

    print("\n".join(results))