def main():
    import sys
    input = sys.stdin.read
    data = input().split()
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    MAX_N = 10**6

    # Предварительно создадим массив smallest_prime, чтобы находить простые делители
    smallest_prime = [0] * (MAX_N + 1)
    for i in range(2, MAX_N + 1):
        if smallest_prime[i] == 0:
            # i — простое число
            for j in range(i, MAX_N + 1, i):
                if smallest_prime[j] == 0:
                    smallest_prime[j] = i

    def is_odd_power(n):
        # Проверяем, что все простые делители имеют нечётную степень
        prev_prime = 0
        count = 0
        while n > 1:
            p = smallest_prime[n]
            c = 0
            while n % p == 0:
                n //= p
                c += 1
            if c % 2 == 0:
                return False
        return True

    # Проходим по диапазону и ищем последовательность из m нечётно-степенных чисел
    count = 0
    start_index = -1
    result_sequence = []

    for num in range(l, r + 1):
        if is_odd_power(num):
            if count == 0:
                start_index = num
            count += 1
            if count == m:
                result_sequence = list(range(start_index, start_index + m))
                break
        else:
            count = 0

    if result_sequence:
        print(" ".join(map(str, result_sequence)))
    else:
        print(-1)

if __name__ == "__main__":
    main()