import sys

input = sys.stdin.read
data = input().split()

n = int(data[0])
m = int(data[1])
k = int(data[2])

counts = [0] * k

full_rows = n
full_cols = m

for i in range(1, n + 1):
    for j in range(1, m + 1):
        color_index = (i + j) % k
        counts[color_index] += 1

total_cells = n * m

row_remainder_counts = [0] * k
col_remainder_counts = [0] * k

for i in range(1, n + 1):
    row_remainder_counts[i % k] += 1

for j in range(1, m + 1):
    col_remainder_counts[j % k] += 1

for r in range(k):
    for s in range(k):
        if (s + r) % k == r:
            counts[r] += row_remainder_counts[s] * col_remainder_counts[(r - s) % k]

for c in counts:
    print(c)