import sys

def main():
    input_data = sys.stdin.read().strip().split()
    t = int(input_data[0])
    pos = 1
    answers = []
    
    for _ in range(t):
        n = int(input_data[pos])
        pos += 1
        
        x_intervals = []
        y_intervals = []
        diag1_intervals = []
        diag2_intervals = []
        
        for i in range(n):
            x1 = int(input_data[pos])
            y1 = int(input_data[pos+1])
            x2 = int(input_data[pos+2])
            y2 = int(input_data[pos+3])
            pos += 4
            
            x_intervals.append((x1, x2))
            y_intervals.append((y1, y2))
            diag1_intervals.append((y1 - x2, y2 - x1))
            diag2_intervals.append((y1 + x1, y2 + x2))
        
        def check_intervals(intervals):
            min_upper = intervals[0][1]
            max_lower = intervals[0][0]
            for l, r in intervals[1:]:
                min_upper = min(min_upper, r)
                max_lower = max(max_lower, l)
            return max_lower <= min_upper
        
        possible = (check_intervals(x_intervals) or 
                   check_intervals(y_intervals) or 
                   check_intervals(diag1_intervals) or 
                   check_intervals(diag2_intervals))
        
        answers.append("Yes" if possible else "No")
    
    sys.stdout.write("\n".join(answers))

if __name__ == "__main__":
    main()