import sys

def solve():
    input_data = sys.stdin.read().strip().split()
    t = int(input_data[0])
    idx = 1
    res = []
    
    for _ in range(t):
        n = int(input_data[idx])
        idx += 1
        rects = []
        
        for i in range(n):
            x1 = int(input_data[idx])
            y1 = int(input_data[idx+1])
            x2 = int(input_data[idx+2])
            y2 = int(input_data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        
        # Вертикальная линия
        min_x = 0
        max_x = 10**9
        for x1, y1, x2, y2 in rects:
            min_x = max(min_x, x1)
            max_x = min(max_x, x2)
        if min_x <= max_x:
            res.append("Yes")
            continue
        
        # Горизонтальная линия
        min_y = 0
        max_y = 10**9
        for x1, y1, x2, y2 in rects:
            min_y = max(min_y, y1)
            max_y = min(max_y, y2)
        if min_y <= max_y:
            res.append("Yes")
            continue
        
        # Диагональ с наклоном 1 (y = x + b)
        min_b = -10**18
        max_b = 10**18
        ok = True
        for x1, y1, x2, y2 in rects:
            b_min = y1 - x2
            b_max = y2 - x1
            min_b = max(min_b, b_min)
            max_b = min(max_b, b_max)
            if min_b > max_b:
                ok = False
                break
        if ok:
            res.append("Yes")
            continue
        
        # Диагональ с наклоном -1 (y = -x + b)
        min_b = -10**18
        max_b = 10**18
        ok = True
        for x1, y1, x2, y2 in rects:
            b_min = y1 + x1
            b_max = y2 + x2
            min_b = max(min_b, b_min)
            max_b = min(max_b, b_max)
            if min_b > max_b:
                ok = False
                break
        if ok:
            res.append("Yes")
        else:
            res.append("No")
    
    sys.stdout.write("\n".join(res))

if __name__ == "__main__":
    solve()