import sys

def solve():
    data = sys.stdin.read().split()
    t = int(data[0])
    idx = 1
    res = []
    
    for _ in range(t):
        n = int(data[idx]); idx += 1
        rects = []
        min_x = 10**9+1
        max_x = -1
        min_y = 10**9+1
        max_y = -1
        
        for i in range(n):
            x1 = int(data[idx]); y1 = int(data[idx+1])
            x2 = int(data[idx+2]); y2 = int(data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
            min_x = min(min_x, x1)
            max_x = max(max_x, x2)
            min_y = min(min_y, y1)
            max_y = max(max_y, y2)
        
        possible = False
        
        for y in [min_y, max_y]:
            ok = True
            for x1, y1, x2, y2 in rects:
                if y < y1 or y > y2:
                    ok = False
                    break
            if ok:
                possible = True
                break
        
        if not possible:
            for x in [min_x, max_x]:
                ok = True
                for x1, y1, x2, y2 in rects:
                    if x < x1 or x > x2:
                        ok = False
                        break
                if ok:
                    possible = True
                    break
        
        if not possible:
            for slope in [1, -1]:
                min_b = -10**18
                max_b = 10**18
                valid = True
                
                for x1, y1, x2, y2 in rects:
                    b1 = y1 - slope * x1
                    b2 = y1 - slope * x2
                    b3 = y2 - slope * x1
                    b4 = y2 - slope * x2
                    
                    r_min = min(b1, b2, b3, b4)
                    r_max = max(b1, b2, b3, b4)
                    
                    min_b = max(min_b, r_min)
                    max_b = min(max_b, r_max)
                    
                    if min_b > max_b:
                        valid = False
                        break
                
                if valid:
                    possible = True
                    break
        
        res.append("Yes" if possible else "No")
    
    sys.stdout.write("\n".join(res))

if __name__ == "__main__":
    solve()