import sys

def solve():
    data = sys.stdin.read().strip().split()
    t = int(data[0])
    idx = 1
    out = []
    
    for _ in range(t):
        n = int(data[idx])
        idx += 1
        
        min_x1 = float('inf')
        max_x2 = float('-inf')
        min_y1 = float('inf')
        max_y2 = float('-inf')
        
        for i in range(n):
            x1 = int(data[idx])
            y1 = int(data[idx+1])
            x2 = int(data[idx+2])
            y2 = int(data[idx+3])
            idx += 4
            
            min_x1 = min(min_x1, x1)
            max_x2 = max(max_x2, x2)
            min_y1 = min(min_y1, y1)
            max_y2 = max(max_y2, y2)
        
        possible = True
        for i in range(0, 4*n, 4):
            x1 = int(data[idx-4*n+i])
            y1 = int(data[idx-4*n+i+1])
            x2 = int(data[idx-4*n+i+2])
            y2 = int(data[idx-4*n+i+3])
            
            if not (min_x1 <= x1 and x2 <= max_x2 and min_y1 <= y1 and y2 <= max_y2):
                possible = False
                break
        
        if possible:
            out.append("Yes")
            continue
        
        possible = False
        
        for slope in [1, -1]:
            min_b = float('-inf')
            max_b = float('inf')
            ok = True
            
            for i in range(0, 4*n, 4):
                x1 = int(data[idx-4*n+i])
                y1 = int(data[idx-4*n+i+1])
                x2 = int(data[idx-4*n+i+2])
                y2 = int(data[idx-4*n+i+3])
                
                b1 = y1 - slope * x1
                b2 = y1 - slope * x2
                b3 = y2 - slope * x1
                b4 = y2 - slope * x2
                
                rect_min_b = min(b1, b2, b3, b4)
                rect_max_b = max(b1, b2, b3, b4)
                
                min_b = max(min_b, rect_min_b)
                max_b = min(max_b, rect_max_b)
                
                if min_b > max_b:
                    ok = False
                    break
            
            if ok:
                possible = True
                break
        
        out.append("Yes" if possible else "No")
    
    sys.stdout.write("\n".join(out))

if __name__ == "__main__":
    solve()