```python
import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().strip().split()
    n = int(data[0])
    K = int(data[1])
    R = int(data[2])
    
    if K == 1:
        print((R + 1) % MOD)
        return
    
    s = bin(R)[2:]
    m = len(s)
    
    dp_cur = [[0, 0] for _ in range(K)]
    dp_cur[0][1] = 1
    
    for i in range(m):
        bit = int(s[i])
        dp_next = [[0, 0] for _ in range(K)]
        
        for rem in range(K):
            val_tight = dp_cur[rem][1]
            val_not_tight = dp_cur[rem][0]
            
            if val_tight:
                if bit == 0:
                    dp_next[rem][1] = (dp_next[rem][1] + val_tight) % MOD
                else:
                    dp_next[rem][0] = (dp_next[rem][0] + val_tight) % MOD
                    new_rem = (rem + 1) % K
                    dp_next[new_rem][1] = (dp_next[new_rem][1] + val_tight) % MOD
            
            if val_not_tight:
                dp_next[rem][0] = (dp_next[rem][0] + val_not_tight) % MOD
                new_rem = (rem + 1) % K
                dp_next[new_rem][0] = (dp_next[new_rem][0] + val_not_tight) % MOD
        
        dp_cur = dp_next
    
    result = (dp_cur[0][0] + dp_cur[0][1]) % MOD
    print(result)

if __name__ == "__main__":
    solve()
```