import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().strip().split()
    n = int(data[0])
    K = int(data[1])
    R = int(data[2])
    
    if K == 1:
        print((R + 1) % MOD)
        return
    
    s = bin(R)[2:]
    m = len(s)
    
    dp_cur = [[0, 0] for _ in range(K)]
    dp_cur[0][1] = 1
    
    for i in range(m):
        bit = int(s[i])
        dp_next = [[0, 0] for _ in range(K)]
        
        for rem in range(K):
            for tight in range(2):
                val = dp_cur[rem][tight]
                if val == 0:
                    continue
                
                max_digit = bit if tight else 1
                
                for d in range(max_digit + 1):
                    new_tight = 1 if (tight and d == bit) else 0
                    new_rem = (rem + d) % K
                    dp_next[new_rem][new_tight] = (dp_next[new_rem][new_tight] + val) % MOD
        
        dp_cur = dp_next
    
    result = (dp_cur[0][0] + dp_cur[0][1]) % MOD
    print(result)

if __name__ == "__main__":
    solve()