import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().strip().split()
    n = int(data[0])
    K = int(data[1])
    R = int(data[2])
    
    if K == 1:
        print((R + 1) % MOD)
        return
    
    s = bin(R)[2:]
    m = len(s)
    
    dp = [[[0, 0] for _ in range(K)] for _ in range(m + 1)]
    dp[0][0][1] = 1
    
    for i in range(m):
        bit = int(s[i])
        for rem in range(K):
            for tight in range(2):
                val = dp[i][rem][tight]
                if val == 0:
                    continue
                
                max_digit = bit if tight else 1
                
                for d in range(max_digit + 1):
                    new_tight = 1 if (tight and d == bit) else 0
                    new_rem = (rem + d) % K
                    dp[i + 1][new_rem][new_tight] = (dp[i + 1][new_rem][new_tight] + val) % MOD
    
    result = (dp[m][0][0] + dp[m][0][1]) % MOD
    print(result)

if __name__ == "__main__":
    solve()