def solve():
    m = int(input())
    l, r = map(int, input().split())
    
    size = r - l + 1
    is_good = [True] * size
    
    n = r
    sieve = [0] * (n + 1)
    primes = []
    
    for i in range(2, n + 1):
        if sieve[i] == 0:
            sieve[i] = i
            primes.append(i)
        for p in primes:
            if p > sieve[i] or i * p > n:
                break
            sieve[i * p] = p
    
    for p in primes:
        start = ((l + p - 1) // p) * p
        for num in range(start, r + 1, p):
            idx = num - l
            cnt = 0
            temp = num
            while temp % p == 0:
                temp //= p
                cnt += 1
            if cnt % 2 == 0:
                is_good[idx] = False
    
    cnt = 0
    for i in range(size):
        if is_good[i]:
            cnt += 1
            if cnt >= m:
                print(' '.join(str(l + i - m + 1 + j) for j in range(m)))
                return
        else:
            cnt = 0
    
    print(-1)

if __name__ == "__main__":
    solve()