import sys

def solve():
    data = sys.stdin.read().strip().split()
    t = int(data[0])
    idx = 1
    results = []
    
    for _ in range(t):
        n = int(data[idx])
        idx += 1
        x_coords = []
        y_coords = []
        
        for i in range(n):
            x1 = int(data[idx])
            y1 = int(data[idx+1])
            x2 = int(data[idx+2])
            y2 = int(data[idx+3])
            idx += 4
            x_coords.extend([x1, x2])
            y_coords.extend([y1, y2])
        
        min_x = min(x_coords)
        max_x = max(x_coords)
        min_y = min(y_coords)
        max_y = max(y_coords)
        
        possible = False
        
        if all(min_x <= x1 and x2 <= max_x for i in range(0, len(x_coords), 2) for x1, x2 in [(x_coords[i], x_coords[i+1])]):
            possible = True
        elif all(min_y <= y1 and y2 <= max_y for i in range(0, len(y_coords), 2) for y1, y2 in [(y_coords[i], y_coords[i+1])]):
            possible = True
        else:
            for slope in [1, -1]:
                min_b = float('-inf')
                max_b = float('inf')
                valid = True
                for i in range(0, len(x_coords), 2):
                    x1, x2 = x_coords[i], x_coords[i+1]
                    y1, y2 = y_coords[i], y_coords[i+1]
                    b_vals = [y1 - slope*x1, y1 - slope*x2, y2 - slope*x1, y2 - slope*x2]
                    min_b = max(min_b, min(b_vals))
                    max_b = min(max_b, max(b_vals))
                    if min_b > max_b:
                        valid = False
                        break
                if valid:
                    possible = True
                    break
        
        results.append("Yes" if possible else "No")
    
    print("\n".join(results))

if __name__ == "__main__":
    solve()