def solve():
    n, m, k = map(int, [input() for _ in range(3)])
    
    if n > m:
        n, m = m, n
    
    result = [0] * k
    total_diags = n + m - 1
    
    # Pre-calculate diag lengths once
    diag_lengths = [0] * total_diags
    for d in range(total_diags):
        if d < n:
            diag_lengths[d] = d + 1
        elif d < m:
            diag_lengths[d] = n
        else:
            diag_lengths[d] = n + m - d - 1
    
    for color in range(k):
        s = 0
        for diag_num in range(color, total_diags, k):
            s += diag_lengths[diag_num]
        result[color] = s
    
    print('\n'.join(map(str, result)))

if __name__ == "__main__":
    solve()