def solve():
    n, m, k = map(int, [input() for _ in range(3)])
    
    if n > m:
        n, m = m, n
    
    result = [0] * k
    
    total_diags = n + m - 1
    full_cycles = total_diags // k
    rem = total_diags % k
    
    for color in range(k):
        diags_with_color = full_cycles + (1 if color < rem else 0)
        if diags_with_color == 0:
            result[color] = 0
            continue
        
        cnt = 0
        for diag_num in range(color, total_diags, k):
            diag_len = 0
            if diag_num < n:
                diag_len = diag_num + 1
            elif diag_num < m:
                diag_len = n
            else:
                diag_len = n + m - diag_num - 1
            cnt += diag_len
        
        result[color] = cnt
    
    print('\n'.join(map(str, result)))

if __name__ == "__main__":
    solve()