def count_magic_up_to(x):
    if x < 7:
        return 0
    
    # A числа, делящиеся на 7
    A = x // 7
    
    # B числа, оканчивающиеся на 7
    B = (x + 3) // 10
    
    # с числа, которые и делятся на 7, и оканчиваются на 7 (7, 77, 147, ...)
    # числа вида 70*t + 7 <= x
    if x >= 7:
        C = (x - 7) // 70 + 1
    else:
        C = 0
    
    return A + B - C

def find_kth_magic(k):
    left = 7 # нижняя гр
    right = 7 * k  # верхняя граница
    while left < right:
        mid = (left + right) // 2
        cnt = count_magic_up_to(mid)
        
        if cnt >= k:
            right = mid
        else:
            left = mid + 1
    
    return left

def main():
    import sys
    k = int(sys.stdin.readline().strip())
    print(find_kth_magic(k))

if __name__ == "__main__":
    main()
