import sys

# Читаем входные данные
n = int(sys.stdin.readline().strip())
m = int(sys.stdin.readline().strip())
k = int(sys.stdin.readline().strip())

# Массив для подсчёта клеток каждого цвета (цвета от 1 до k)
count = [0] * k

# Перебираем все возможные суммы i + j (от 2 до n + m)
for s in range(2, n + m + 1):
    # Определяем цвет для диагонали s
    color_index = (s - 2) % k  # 0..k-1
    
    # Считаем число клеток на диагонали s
    if s <= min(n, m) + 1:
        cells = s - 1
    elif s <= max(n, m) + 1:
        cells = min(n, m)
    else:
        cells = n + m - s + 1
    
    # Добавляем к соответствующему цвету
    count[color_index] += cells

# Выводим результаты (по одному числу в строке)
for c in count:
    print(c)
