def precompute_min_prime_divisors(max_n):
    """Вычисляет минимальный простой делитель для каждого числа до max_n."""
    min_prime = list(range(max_n + 1))  
    for i in range(2, int(max_n**0.5) + 1):
        if min_prime[i] == i:  
            for j in range(i * i, max_n + 1, i):
                if min_prime[j] == j:
                    min_prime[j] = i
    return min_prime

def is_odd_power_number(n, min_prime):
    """Проверяет, является ли n нечётно-степенным числом."""
    if n == 1:
        return True  
    
    temp = n
    while temp > 1:
        p = min_prime[temp]
        count = 0
        while temp % p == 0:
            temp //= p
            count += 1
        if count % 2 == 0:  
            return False
    return True

def solve():
    import sys
    input = sys.stdin.read
    data = input().split()
    
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])
    
    max_n = r
    min_prime = precompute_min_prime_divisors(max_n)
    
    
    is_odd_power = [False] * (max_n + 1)
    for n in range(2, max_n + 1):
        is_odd_power[n] = is_odd_power_number(n, min_prime)
    
    
    result = -1
    for start in range(l, r - m + 2):  
        valid = True
        for i in range(start, start + m):
            if not is_odd_power[i]:
                valid = False
                break
        if valid:
            result = start
            break
    
  
    if result == -1:
        print(-1)
    else:
        print(' '.join(str(x) for x in range(result, result + m)))

if __name__ == "__main__":
    solve()
