def count_magic_numbers(n):
    """Возвращает количество магических чисел <= n."""
    if n < 7:
        return 0
    
    div_by_7 = n // 7
    ends_with_7 = (n + 3) // 10
    both = (n - 7) // 70 + 1  
    
    return div_by_7 + ends_with_7 - both

def find_kth_magic_number(k):
    """Находит k-е магическое число."""
    if k == 1:
        return 7
    
    left = 1
    right = 7 * k  
    
    while left < right:
        mid = (left + right) // 2
        cnt = count_magic_numbers(mid)
        
        if cnt < k:
            left = mid + 1
        else:
            right = mid
    
    return left

k = int(input())
print(find_kth_magic_number(k))
