def get_color(i, j):
    """Возвращает цвет клетки (i, j) по правилу задачи."""
    group = i + j  
    color_num = (group - 2) % 3 + 1
    colors = {1: "зелёный", 2: "красный", 3: "синий"}
    return colors[color_num]

def print_road(n):
    """Печатает раскраску дороги размером n x n."""
    print(f"Раскраска дороги {n}x{n}:")
    for i in range(1, n + 1):
        row = []
        for j in range(1, n + 1):
            color = get_color(i, j)
            row.append(f"({i},{j}): {color}")
        print(" | ".join(row))


if __name__ == "__main__":
    n = 4  
    print_road(n)
