def solve():
    import sys
    
    m = int(input())
    l, r = map(int, input().split())
    
    # Инициализация решета для нахождения наименьшего простого делителя
    N = r + 5
    spf = list(range(N))  # smallest prime factor
    for i in range(2, int(N**0.5) + 1):
        if spf[i] == i:
            for j in range(i*i, N, i):
                if spf[j] == j:
                    spf[j] = i
    
    good = [True] * (r + 1)
    good[0] = good[1] = False
    
    # Проверяем каждое число от 2 до r
    for n in range(2, r + 1):
        temp = n
        # Разлагаем на простые множители через spf
        while temp > 1:
            p = spf[temp]
            cnt = 0
            while temp % p == 0:
                temp //= p
                cnt += 1
            if cnt % 2 == 0:  # чётная степень
                good[n] = False
                break
    
    # Поиск m подряд идущих хороших чисел в [l, r]
    start = -1
    count = 0
    for i in range(l, r + 1):
        if good[i]:
            count += 1
            if count == 1:
                current_start = i
            if count == m:
                start = current_start
                break
        else:
            count = 0
    
    if start == -1:
        print(-1)
    else:
        print(' '.join(str(x) for x in range(start, start + m)))

if __name__ == "__main__":
    solve()
