def main():
    import sys
    input = sys.stdin.read
    data = input().split()
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    MAX_N = 10 ** 6

    # Массив для хранения, является ли число нечётно-степенным
    is_odd_power = [True] * (MAX_N + 1)
    is_odd_power[0] = False
    is_odd_power[1] = True  # 1 не имеет простых делителей, считаем его нечётно-степенным

    # Массив для хранения smallest prime factor (SPF) для каждого числа
    spf = [0] * (MAX_N + 1)

    # Построение SPF с помощью варианта решета
    for i in range(2, MAX_N + 1):
        if spf[i] == 0:
            spf[i] = i
            for j in range(i * i, MAX_N + 1, i):
                if spf[j] == 0:
                    spf[j] = i

    # Проверка для каждого числа
    for num in range(2, MAX_N + 1):
        temp = num
        is_odd = True
        while temp > 1:
            p = spf[temp]
            count = 0
            while spf[temp] == p:
                temp //= p
                count += 1
            # Проверяем показатель степени
            if count % 2 == 0:
                is_odd = False
                break
        is_odd_power[num] = is_odd

    # Ищем последовательность из m подряд идущих нечётно-степенных чисел
    count = 0
    start_index = -1
    for num in range(l, r + 1):
        if is_odd_power[num]:
            if count == 0:
                start_index = num
            count += 1
            if count == m:
                print(' '.join(str(x) for x in range(start_index, start_index + m)))
                return
        else:
            count = 0

    # Если не нашли
    print(-1)


if __name__ == "__main__":
    main()