def main():
    import sys
    data = sys.stdin.read().split()
    n = int(data[0])
    m = int(data[1])
    k = int(data[2])

    # Функция для подсчета суммы длин диагоналей, у которых s ≡ start_mod (mod k),
    # для s в диапазоне [low, high]
    def sum_for_mod(start_mod, low, high):
        # Находим первый s >= low, s ≡ start_mod (mod k)
        if (low - start_mod) % k != 0:
            low = low + (start_mod - (low - start_mod) % k) % k
        # Аналогично для high
        if (high - start_mod) % k != 0:
            high = high - (high - start_mod) % k
        if low > high:
            return 0
        count = ((high - low) // k) + 1

        # сумма арифметической прогрессии с первым членом = length_for_first, разностью = k
        def length_for_diag(s):
            return max(0, min(n, m, s - 1, n + m -  + 1))

        # Посчитаем сумму по всем s
        total = 0
        s = low
        for _ in range(count):
            total += length_for_diag(s)
            s += k
        return total

    results = [0] * k
    for c in range(1, k + 1):
        start_mod = (c - 1) % k
        total_cells = sum_for_mod(start_mod, 2, m + n)
        results[c - 1] = total_cells

    for res in results:
        print(res)


if __name__ == "__main__":
    main()