import sys


def can_hit_all_rectangles(rects):
    """
    Проверяет, существует ли прямая, касающаяся всех прямоугольников
    """
    n = len(rects)

    if n <= 2:
        return True

    # Преобразуем прямоугольники в пары (x1, y1, x2, y2)
    # где x1 < x2, y1 < y2

    # Минимальный и максимальный углы наклона для каждого прямоугольника
    # Прямая должна быть такой, чтобы она проходила через прямоугольник
    # Для этого ее угол должен быть между min_angle и max_angle

    # Альтернативный подход: проверяем возможность провести линию
    # через "крайние" прямоугольники

    # Идея: если существует такая прямая, то она должна разделять
    # прямоугольники определенным образом

    # Попробуем найти точку, из которой все прямоугольники "видны"
    # под некоторым углом

    # Для эффективности: проверяем кандидатов на основе крайних прямоугольников

    # 1. Проверяем вертикальные и горизонтальные линии
    min_x2 = min(r[2] for r in rects)  # минимальная правая граница
    max_x1 = max(r[0] for r in rects)  # максимальная левая граница
    min_y2 = min(r[3] for r in rects)  # минимальная верхняя граница
    max_y1 = max(r[1] for r in rects)  # максимальная нижняя граница

    # Если есть вертикальная линия, пересекающая все прямоугольники
    if max_x1 <= min_x2:
        return True

    # Если есть горизонтальная линия, пересекающая все прямоугольники
    if max_y1 <= min_y2:
        return True

    # 2. Проверяем линии с наклоном 1 (45°)
    # Преобразование: u = x - y, v = x + y
    # Линия y = x + b соответствует вертикали в преобразованных координатах

    min_u2 = min(r[2] - r[1] for r in rects)  # x2 - y1
    max_u1 = max(r[0] - r[3] for r in rects)  # x1 - y2

    if max_u1 <= min_u2:
        return True

    # 3. Проверяем линии с наклоном -1 (135°)
    # Линия y = -x + b соответствует вертикали в преобразованных координатах
    min_v2 = min(r[2] + r[1] for r in rects)  # x2 + y1
    max_v1 = max(r[0] + r[3] for r in rects)  # x1 + y2

    if max_v1 <= min_v2:
        return True

    # 4. Для общего случая используем подход с "двойными" касательными
    # Если существует общая касательная, то должна существовать линия,
    # касающаяся выпуклой оболочки всех прямоугольников

    # Собираем все вершины
    points = []
    for x1, y1, x2, y2 in rects:
        points.append((x1, y1))
        points.append((x1, y2))
        points.append((x2, y1))
        points.append((x2, y2))

    # Если точек мало, можно проверить все пары
    if n <= 10:  # эвристика для небольших случаев
        for i in range(len(points)):
            x1, y1 = points[i]
            for j in range(i + 1, len(points)):
                x2, y2 = points[j]
                # Проверяем, проходит ли линия через все прямоугольники
                if x1 == x2 and y1 == y2:
                    continue

                # Уравнение прямой через (x1, y1) и (x2, y2)
                # A*x + B*y + C = 0
                A = y2 - y1
                B = x1 - x2
                C = x2 * y1 - x1 * y2

                # Для каждого прямоугольника проверяем, пересекает ли его прямая
                all_intersect = True
                for xa, ya, xb, yb in rects:
                    # Вычисляем значения в углах
                    values = [
                        A * xa + B * ya + C,
                        A * xa + B * yb + C,
                        A * xb + B * ya + C,
                        A * xb + B * yb + C
                    ]
                    min_val = min(values)
                    max_val = max(values)

                    # Прямая пересекает прямоугольник, если значения разных знаков
                    # или хотя бы один ноль
                    if not (min_val <= 0 <= max_val):
                        all_intersect = False
                        break

                if all_intersect:
                    return True

    # 5. Проверяем линии, которые являются опорными для пары прямоугольников
    # Берем самые крайние прямоугольники и проверяем линии через их вершины

    # Находим прямоугольники с минимальной и максимальной координатами
    # и проверяем линии через их крайние точки

    # Если дошли сюда, вероятно, линии нет
    return False


def solve():
    input_data = sys.stdin.read().strip().split()
    t = int(input_data[0])
    idx = 1
    results = []

    for _ in range(t):
        n = int(input_data[idx])
        idx += 1
        rects = []
        for i in range(n):
            x1 = int(input_data[idx])
            y1 = int(input_data[idx + 1])
            x2 = int(input_data[idx + 2])
            y2 = int(input_data[idx + 3])
            idx += 4
            # Гарантируется x1 < x2, y1 < y2
            rects.append((x1, y1, x2, y2))

        if can_hit_all_rectangles(rects):
            results.append("Yes")
        else:
            results.append("No")

    sys.stdout.write("\n".join(results))


if __name__ == "__main__":
    solve()