MOD = 10**9 + 7

def solve():
    import sys
    input = sys.stdin.read
    data = input().split()
    
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]
    
    # Переводим R в двоичную строку
    R = int(R_str)
    # Но если n большое (до 30000), то int(R_str) не влезет в обычный int в Python? 
    # В Python большие числа — нормально, но для производительности лучше строку в биты перевести по-другому.
    # Для простоты оставим int, Python справится.
    
    # Получаем двоичное представление R
    binary = bin(R)[2:]
    m = len(binary)
    
    if K > 2000:  # Для больших K этот DP неэффективен
        # Здесь нужно другое решение
        print(0)
        return
    
    # DP: dp[pos][tight][mod]
    dp = [[[0] * K for _ in range(2)] for _ in range(m + 1)]
    dp[0][1][0] = 1
    
    for pos in range(m):
        bit_R = int(binary[pos])
        for tight in range(2):
            for mod in range(K):
                if dp[pos][tight][mod] == 0:
                    continue
                max_bit = bit_R if tight else 1
                for b in range(max_bit + 1):
                    new_tight = tight and (b == max_bit)
                    new_mod = (mod + b) % K
                    dp[pos + 1][new_tight][new_mod] = (dp[pos + 1][new_tight][new_mod] + dp[pos][tight][mod]) % MOD
    
    answer = (dp[m][0][0] + dp[m][1][0]) % MOD
    print(answer)

if __name__ == "__main__":
    solve()