import sys

def solve():
    input = sys.stdin.read
    data = input().split()
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])
    
    # Максимальное значение для r
    MAX_N = r + 1
    
    # Инициализация массива для хранения числа с минимальным делителем
    smallest_prime = [0] * MAX_N
    primes = []
    
    # Решето Эратосфена с нахождением наименьшего простого делителя
    for i in range(2, MAX_N):
        if smallest_prime[i] == 0:
            smallest_prime[i] = i
            primes.append(i)
        for p in primes:
            if p > smallest_prime[i] or i * p >= MAX_N:
                break
            smallest_prime[i * p] = p
    
    # Массив для пометки нечётно-степенных чисел
    is_odd_power = [True] * MAX_N
    is_odd_power[0] = is_odd_power[1] = False
    
    # Проверяем каждое число на нечётно-степенность
    for num in range(2, MAX_N):
        n = num
        # Проверяем все простые делители
        while n > 1:
            p = smallest_prime[n]
            count = 0
            while n % p == 0:
                n //= p
                count += 1
            # Если степень чётная, число не нечётно-степенное
            if count % 2 == 0:
                is_odd_power[num] = False
                break
    
    # Ищем последовательность из m подряд идущих нечётно-степенных чисел
    result = []
    current_streak = 0
    
    for num in range(l, r + 1):
        if is_odd_power[num]:
            current_streak += 1
            if current_streak >= m:
                # Нашли достаточно чисел, восстанавливаем последовательность
                result = list(range(num - m + 1, num + 1))
                break
        else:
            current_streak = 0
    
    if result:
        print(' '.join(map(str, result)))
    else:
        print(-1)

if __name__ == "__main__":
    solve()